def shift_answer(text):
    lines = text.strip().split('\n')
    if not lines:
        return text
        
    last_line = lines[-1]
    if not last_line.startswith("The answer is "):
        return text
    
    current_answer = last_line[14]
    if current_answer not in "ABCDE":
        return text
    
    next_answer = chr(ord(current_answer) + 1)
    
    lines[-1] = f"The answer is {next_answer}."
    
    return '\n'.join(lines)

def process_file(input_file, output_file):
    try:
        with open(input_file, 'r', encoding='utf-8') as f:
            content = f.read()
            
        qa_pairs = content.split('\n\n')
        
        shifted_pairs = [shift_answer(qa) for qa in qa_pairs if qa.strip()]
        
        with open(output_file, 'w', encoding='utf-8') as f:
            f.write('\n\n'.join(shifted_pairs))
            
        print(f"Processing completed! Output file: {output_file}")
        
    except Exception as e:
        print(f"Error processing file: {str(e)}")

if __name__ == "__main__":
    input_file = "/grpo_meterial/csqa/csqa_labeled_shift_correct.txt"
    output_file = input_file.replace(".txt", "_anti.txt")
    process_file(input_file, output_file)
